## 24.1 什么是平行结构
### 24.1.1 基本概念
**概念**
+ 概念：
	+ 平行结构：又称之为**并列结构**，几个成分并列在一起、重要性相同；
+ 特点：
	+ 1. 平行、并列的多个成分之间，必须**词性相同、形式一致**的；
		+ 想并到一起的，必须词性一致，比如 `介词、介词、介词`
		+ 而且还得形式一致；
	+ 2. 依靠**并列连词（或者并列词组）** 连接在一起，四类并列连词；
		+ 所以：并列句就是平行结构当中的一种；
		+ 四类连词：and、but、or、nor、not only（not just...but alse）、also
		+ 标点：逗号、分号
		+ 即：平行并列的成分之间，一般是词性相同、形式一致的；
+ 注意：
	+ 如果多个成分并列，中间并列连词相等，此时可以前面的连词省略，替换使用逗号；

**三步法：找到平行结构**
+ 第一步：
	+ 找到并列连词；
+ 第二步：
	+ 往并列连词后看，看接的内容是什么形式；
+ 第三步：
	+ 往前找和它形式一样的

**关于并列结构的数量**
+ 情况一：
	+ 如果句子当中是两个成分并列
	+ 则此时只需要直接使用 and 连接即可：`1` and `2`
+ 情况二：
	+ 如果是句子当中是多个成分并列，比如有 1、2、3 个成分
	+ 则此时只需要在最后一个句子前使用 and 成分：`1`，`2`，and `3` 
	+ 或者五个句子是：`1`，`2`，`3`，`4` and `5`

### 24.1.2 平行结构分类 
**四类结构**
+ (一)名词 (词组)的平行并列
+ (二)动词 (谓语动词、非谓语动词)的平行并列 
+ (三)介词短语的平行并列 
+ (四)句子的平行并列

## 24.2 四类平行结构
### 24.2.1 名词、词组的平行并列
**举例**
+ *The English, the Germans, the Dutch and the French were investing in Britain's former colony.*
	+ 找主语 `->` 找谓语动词 `->` were inveting `->` 主语：**The English, the Germans, the Dutch and the French** `<-` 四个内容并列在一起；
	+ 图示：
		+ ![[Pasted image 20240416212602.png]]
+ *The networked computer is an amazing device, the first mediamachine that serves as the mode of production, means ofdistribution, site of reception, and place of praise and critique.*
	+  图示：![[Pasted image 20240416212744.png]]
	+ as：作为什么来服务 -> 四种服务：
		+ 1 the mode of produetion 
		+ 2 means of distribution 
		+ 3 site of reception 
		+ 4 and place of praise and critique.
	+ 注意：可以对平行的内容进行标数字；

### 24.2.2 动词的平行并列
**概念**
+ 注意：   
	+ 谓语、非谓语都可以平行并列；
+ 技巧：
	+ 想知道当前并列连词中被并列的部分是从哪里到哪里，可以看并列连词（比如 and）后背的第一个词，看其词性。其前半部分的句子中属于这个词性的词语就是前半部分被并列句子的开始；

**举例**
+ *The process sweeps from hyperactive America to Europe andreaches the emerging countries with unsurpassed might.*
	+ 两个谓语动词被并列；
	+ 图示： ![[Pasted image 20240416213250.png]]
+ *It allows us to have perspective on our lives-the ability to nottake ourselves too seriously, to laugh at ourselves, to see the bigger picture, and to see that things will work out.*
	+ 并行结构；to do 非谓语动词并列；
	+ ![[Pasted image 20240416213505.png]]
+ *Two and three-dimensional maps are helpful tools in planning excavations, illustrating how sites look, and presenting the results of archaeological research*
	+ 都跟在 in 后背的非谓语动词（doing）并列；
	+ 图示：![[Pasted image 20240416213723.png]]
+ *The financial crisis has made it more acceptable to be between jobs or to leave a bad one.*
	+ 结构：主谓宾补
		+ 主语：The financial crisis 
		+ 谓语：has made
		+ 宾语：it（形式宾语）
		+ 补语：more acceptable to be between jobs or to leave a bad one
	+ 真正的宾语：to be between jobs or to leave a bad one
		+ 平行结构； 
	+ 图示：![[Pasted image 20240416214028.png]]

### 24.2.3 介词短语的平行并列 
**举例**
+ *... He advocated freedom of thought and of personal expression.*
	+ 图示：![[Pasted image 20240416214159.png]]
	+ 两个介词并列，一起修饰前面的 freedom；
+ *Mental health allows us to view others with sympathy if they arehaving troubles, with kindness if they are in pain, and withunconditional love no matter who they are.*
	+ ![[Pasted image 20240416222043.png]]
+ *So disciplines acquire a monopoly not just over the production ofknowledge, but also over the production of the producers of knowledge.*

### 24.2.4 句子的平行并列 
**举例**
+ *the problem is not merely that people do bad science, but that aoour current sustem of career advancement positively encourages it.*
	+ 并列连词：not merely ... But...
	+ 图示：![[Pasted image 20240416222413.png]]
+ *The behavioral sciences have been slow to change partly becausethe explanatory items often seem to be directly observed andpartly because other kinds of explanations have been hard to find.*
	+ ![[Pasted image 20240416222621.png]]
+ *However, <u>whether such a sense of fairness evolved independentlyin capuchins and humans, or whether it stems from the commonancestor that the species had 35 million years ago</u>, is, as yet, anunanswered question.*
	+ 两个主语从句；
	+ 由于第一个主语从句太长，所以使用逗号停顿；

### 24.2.5 补充：多个平行结构 
**补充**
+ 概念：
	+ 一般多个平行并列的时候，只有最后一个会使用 and；

**举例**
+ *The development of the Elizabethan drama for the next twenty-fiveyears is of exceptional interest to students of literary history, forin this brief period we may trace the beginning, growth, blossoming, and decay of many kinds of plays, and of many great careers.*
+ *For the time, attention, and money of the art-loving public, classicalinstrumentalists must compete not only with opera houses, dancetroupes, theater companies, and museums, but also with the recordedperformances of the qreat classical musicians of the 20 th century*

### 24.2.6 补充：无并列连词的平行结构 
**举例**
+ *“Those first few days should be spent looking for work, notlooking to sign on,” he claimed.*

## 24.3 真题演练
**举例**
+ *In addition, new digital technologies have allowed more rapid trading of equities , quicker use of information at thespeed of Twitter ,<u>and</u> thus shorter attention spans infinancial markets.*
	+ 第一步：并列连词 `->` And
		+ 找到并列结构为 and；
	+ 第二步：找到并列形式；
		+ 这句话：thus shorter attention spans infinancial markets `->` 形式一致的成分；
	+ 第三步：找到形式一致的成分
		+ 三个分叉；
		+ 1. More rapid trading of equities；
		+ 2. Quicker use of information at thespeed of Twitter；
		+ 3. Thus shorter attention spans infinancial markets；
+ *The court's ruling is a step forward in the struggleagainst both corruption and official favoritism.*
	+ 并列连词：both... And
+ *The court's ruling is a step forward in the struggleagainst both corruption and official favoritism.*
	+ 并列连词：either... Or
+ *Grammar , punctuation, and spelling can wait until you revise.*
	+ 并列连词：and
	+ 三个成分连接在一起，然后使用逗号来连接；
+ *But we are now knowledgeable enough to reduce many ofthe risks that threatened the existence of earlier humansand to improve the lot of those to come.*
	+ 并列连词：and 
	+ 并列成分：两个 to do 的词组；
+ *The point of a style upgrade isn't to become more vain orto spend more time fussing over what to wear.*
	+ 并列连词：or
	+ 并列成分：to do 的词组
		+ to become more vain
		+ to spend more time fussing
+ *Teachers are responsible for teaching kids how to learn<u>；</u>parents should be responsible for teaching them how towork.*
	+ 并列连词：分号 "；"
+ *In one case, many researchers working around the ancient Maya city of Copán, Honduras, have located hundreds of smallrural villages and individual dwellings by using aerial photographs and by making surveys on foot.*
	+ 第一个平行结构：
		+ hundreds of smallrural villages **and** individual dwellings
	+ 第二个平行结构：
		+ by using aerial photographs **and** by making surveys on foot

## 24.4 考场攻略
**攻略一**：解决分裂机构的关键，是还原成连贯的句子
+ 两种分裂：
	+ 插入分裂；
	+ 从句后移分裂；
+ 概念：
	+ 找到分裂之后，把分裂的句子解决掉（去除、移动），就可以形成连贯的句子；
+ 举例：
	+ *Bob Liodice<u>, the chief executive of the Association of Nationa Advertisers, </u>says consumers will be worse off if the industrycannot collect information about their preferences.*
		+ 插入的部分可以先直接省略、不看；

**攻略二**：解决嵌套结构的关键，是将句子分层次
+ 方法：
	+ 第一步：正常断开句子
	+ 第二步：大圈、小圈分开看，先看大圈（主句），再看小圈
+ 举例：
	+ *If we are serious about ensuring that our science is bothmeaningful andreproducible, we must ensure that our institutionsincentivise that kind of science.*
		+ ![[Pasted image 20240420223507.png]]

**攻略三**：解决平行结构的关键，是理清多个并列
+ 概念：
	+ 1. 平行、并列的多个成分之间，必须**词性相同、形式一致**的；
	+ 2. 依靠**并列连词（或者并列词组）** 连接在一起，四类并列连词；
+ 方法：三步法
	+ 第一步：找并列连词；
	+ 第二步：往并列连词后看，看起句子形式、成分；
	+ 第三步：往并列连词前面看，找一样的句子形式、成分；
+ 技巧：
	+ 可以在并列句当中标数字，表示是第几个句子；
+ 举例：
	+ *Simply arranging a meeting, making a phone call, or hosting anevent is not an “official act".*
		+ 并列句：
			+ arranging a meeting 
			+ making a phone call
			+ hosting anevent 
		+ 为什么谓语动词不是用复数？而是用 is？
			+ 因为是用的 or 作为并列连词，表示是当中“一个”；

**攻略四**：考研真题、逢长难句处必出题
+ 举例：
	+ *As a linguist, he acknowledges that all varieties of humanlanguage, including non-standard ones like Black English, can bepowerfully expressive-there exists no language or dialect inthe world that cannot convey complex ideas.*
		+ 第一步：找谓语动词
			+ acknowledges：承认
			+ can be：情态动词，接动词原形
			+ exist 
			+ cannot convey：否定
		+ 第二步：找标点、连接词
			+ 破折号：一个破折号是解释说明；
			+ 两个逗号：插入语，可以去掉；
			+ that：连接词
		+ 断开后：
			+ 1. As a linguist, he acknowledges
			+ 2. That all varieties of human language, ......, can be powerfully expressive
				+ 插入的部分：including non-standardones like Black English
			+ 3. --there exists no language or dialect in the world
			+ 4. That cannot convey complex ideas `->` 修饰 `no language or dialect`
				+ 用于加强肯定 -> 分裂结构，挪到了 `in the world` 后背 `->` 可以把句子放到 `in the world` 前面；；
	+ *young people who are still getting started in life were more likely thanolder adults to prioritize personal fulfillment in their work, to believethey will advance their careers most by regularly changing jobs, to favorcommunities with more public services and a faster pace of life, to agreethat couples should be financially secure before getting married orhaving children, and to maintain that children are best served by twoparents working outside the home...*
		+ 典型的平行结构；
			+ ![[Pasted image 20240420225514.png]]
		+ 